using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using ICSharpCode.SharpZipLib.Zip;
using ICSharpCode.SharpZipLib.Checksums;

/* to free cart after exporting (seems it is working like this now???) 
 
 *  keep cache in temp file, modify the seach funtion to use cached result
 */

public partial class checkout : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {           

            bool isComplete = false;
            if (Request.QueryString["complete"] != null)
            {
                isComplete = (Request.QueryString["complete"] == "1") ? true : false;
            }

            if (isComplete)
            {
                /* not update the trolley, leave the option to user at the moment */
                //Session["cart"] = null;
               // GridViewCheckout.DataSource = null;
               // GridViewCheckout.DataBind();
                bindGrid();

                LblMsg.Text = "Learning objects have been exported!";
            }
            else
            {
                bindGrid();

                string fileHref = prepareDowloadFiles();

                if (fileHref != null)
                {
                    HLexport.NavigateUrl = fileHref;

                    /* use javascript to refresh the page in 10 seconds. might not be the best option 
                       can be disabled to give users the option to clear trolley
                     */
                    string timerScript = "<script language='javascript'>" + "window.setTimeout('location=\"checkout.aspx?complete=1\"', 10000);</script>";

                    Literal1.Text = timerScript;
                   
                }
            }
        }

    }


    private void bindGrid()
    {
        LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;

        GridViewCheckout.DataSource = curSets;
        GridViewCheckout.DataBind();

        if (curSets == null || curSets.Rows.Count == 0)
        {
            LblMsg.Text = "No files to export!";
            HLexport.Visible = false;
            BtnClearTrolley.Visible = false;
        }
        else
        {
            LblMsg.Text = "The following Learning Objects / Assets will be exported in a zip package";
        }

        

    }


    private string prepareDowloadFiles()
    {
        LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;

        if (curSets == null || curSets.Rows.Count == 0)
        {
            return null;
        }

        string filepath = Server.MapPath(@"App_Data\temp\");
        Guid gid = Guid.NewGuid();
        filepath += gid.ToString() + "\\";  //try to make a uniqe temp folder

        if (!Directory.Exists(filepath))
        {
            Directory.CreateDirectory(filepath);
        }

        //write file binaries to files based on their names (in a temp folder)
        for (int i = 0; i < curSets.Rows.Count; i++)
        {
            string fileString = curSets.Rows[i]["content"].ToString();
            byte[] fileBinaries = Convert.FromBase64String(fileString);

            string fileNm = filepath + curSets.Rows[i]["filename"].ToString();

            FileStream fs = null;
            try
            {
                fs = new FileStream(fileNm, FileMode.Create, FileAccess.Write);
                fs.Write(fileBinaries, 0, fileBinaries.Length);
            }
            catch (IOException ex)
            {
                Response.Write(ex.Message);
            }
            finally
            {
                fs.Close();
            }

        }

        //create zip files  (need to remove temp file afterwards)  
        string zipName = "Your_LO_package";
        ZipOutputStream zstream = createZipFile(filepath,gid.ToString(), zipName, null);
        zstream.Finish();
        zstream.Close();
        
        //remove the files apart from the zip file for download
        deleteFiles(filepath, zipName);

        //use this can save some efforts of loading another page, the file will be deleted in global.asax
        string fileURL = "~/download/" + gid.ToString() + "/" + zipName + ".zip";

        //either way works, this can delete the files in the download page
        //string fileURL = "download.aspx?dir=" + gid.ToString() + "&name=" + zipName;
        return fileURL;

    }

    
    protected void GridViewCheckout_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            Label lblType = (Label)e.Row.FindControl("lbltype");

            LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;

            if (curSets != null && curSets.Rows.Count != 0)
            {
                int reposType = Convert.ToInt32(curSets.Rows[e.Row.RowIndex]["reposType"]);
                switch (reposType)
                {
                    case 1:
                        lblType.Text = "CLARe";
                        break;
                    case 2:
                        lblType.Text = "Jourm";
                        break;
                    case 3:
                        lblType.Text = "LLAS";
                        break;
                }
            }

           
        }
            
           
    }


    protected void BtnExport_Click(object sender, ImageClickEventArgs e)
    {
        LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;

        string filepath = Server.MapPath(@"App_Data\temp\");
        Guid gid = Guid.NewGuid();
        filepath += gid.ToString() + "\\";  //try to make a uniqe temp folder

        if (!Directory.Exists(filepath))
        {
            Directory.CreateDirectory(filepath);
        }
      
        //write file binaries to files based on their names (in a temp folder)
        for (int i = 0; i < curSets.Rows.Count; i++)
        {
            string fileString = curSets.Rows[i]["content"].ToString();
            byte[] fileBinaries = Convert.FromBase64String(fileString);

            string fileNm = filepath + curSets.Rows[i]["filename"].ToString();

            FileStream fs = null;
            try
            {
                fs = new FileStream(fileNm, FileMode.Create, FileAccess.Write);
                fs.Write(fileBinaries, 0, fileBinaries.Length);
            }
            catch (IOException ex)
            {
                Response.Write(ex.Message);
            }
            finally
            {
                fs.Close();
            }

        }

        //create zip files  (need to remove temp file afterwards)  
        string zipName = "Your_LO_package";
        ZipOutputStream zstream = createZipFile(filepath,gid.ToString(), zipName, null);
        zstream.Finish();
        zstream.Close();

        //remove the files apart from the zip
        deleteFiles(filepath, zipName);

        //export package method 1
        Response.AppendHeader("Refresh", "0;URL=download.aspx?dir=" + gid.ToString() + "&name=" + zipName);
        
        //Response.Redirect("download.aspx?dir=" + gid.ToString() + "&name=" + zipName);
      
        //this won't work after response flush, exporting files??
        //not sure if this is good enough
        //aim is to remove files from temp folder afer downloading
        /*  
        const int TIMEOUT = 120000;
        int timespans = 0;
        while (Session["isComplete"] == null)
        {
            if (timespans < TIMEOUT)
            {
                System.Threading.Thread.Sleep(5000);
                timespans += 5000;
            }
            else
            {
                ApplicationException ex = new ApplicationException("timeout");
                throw new HttpException(ex.Message);
            }
        }
        */

        GridViewCheckout.DataSource = null;
        GridViewCheckout.DataBind();
        LblMsg.Text = "Learning objects have been exported at this point!";
        //BtnExport.Visible = false;
        Session["cart"] = null;
       // Directory.Delete(filepath, true);  //can't delete it here. do this from download page
      

       // Response.Redirect("download.aspx?dir=" + gid.ToString() + "&name=" + zipName);
       /*  method 2. the page content rewrite and refresh is not working (those for gridview and labels)
        * even the page freshing part is before the exportPackage part, nothing will display
        bool isCompleted = exportPackage(filepath, zipName);
       
        if (isCompleted)        
        {
            Directory.Delete(filepath, true);
            Session["cart"] = null;

            //Response.Redirect("checkout.aspx?complete=1");  
            GridViewCheckout.DataSource = null;
            GridViewCheckout.DataBind();
            LblMsg.Text = "Learning objects have been exported at this point!";
            BtnExport.Visible = false;
        }
       */
     

    }


    /* not in use */
    private bool exportPackage(string pPath, string pName)
    {
        string zipPath = pPath + pName + ".zip";
        FileInfo zipfile = new FileInfo(zipPath);

        //Clear the current output content from the buffer
        Response.Clear();

        pName = pName + ".zip";

        try
        {

            //Add the header that specifies the default filename for the Download/SaveAs dialog
            Response.AddHeader("Content-Disposition", "attachment;filename=" + pName);

            //Add the header that specifies the file size, so that the browser 
            //can show the download progress
            Response.AddHeader("Content-Length", zipfile.Length.ToString());

            //Specify that the response is a stream that cannot be read by the client 
            //and must be downloaded
            Response.ContentType = "application/zip";

            //Send the file stream to the client
            Response.WriteFile(zipfile.FullName);

            //Stop the execution of this page
            //Response.End();
            Response.Flush();
            Response.Close();
            

            return true;
        }
        catch (Exception e)
        {
            return false;
        }


    }



    private ZipOutputStream createZipFile(string zpath, string gid, string zName, ZipOutputStream zipStream)
    {
        string[] filenames = Directory.GetFiles(zpath);


        Crc32 crc = new Crc32();

        //initialize zipStream if it is not set.if should be set only once
        if (zipStream == null)
        {
            string downloadPath = Server.MapPath(@"download\") + gid + "\\";
            if (!Directory.Exists(downloadPath))
            {
                Directory.CreateDirectory(downloadPath);
            }
            string zfile = downloadPath + zName + ".zip";

            zipStream = new ZipOutputStream(File.Create(zfile));

            zipStream.SetLevel(6); // 0 - store only to 9 - means best compression
        }

        foreach (string file in filenames)
        {
            FileStream fs = File.OpenRead(file);

            byte[] buffer = new byte[fs.Length];
            fs.Read(buffer, 0, buffer.Length);
            //important!...to position the subdirectory/files relation,
            //need to remove the root path,just leave relative path
            ZipEntry entry = new ZipEntry(file.Substring(zpath.Length));

            entry.DateTime = DateTime.Now;

            entry.Size = fs.Length;
            fs.Close();

            crc.Reset();
            crc.Update(buffer);

            entry.Crc = crc.Value;

            zipStream.PutNextEntry(entry);

            zipStream.Write(buffer, 0, buffer.Length);

        }
        string[] subdirs = Directory.GetDirectories(zpath);
        foreach (string dir in subdirs)
        {
            createZipFile(dir, gid, zName, zipStream);
        }

        return zipStream;

    }


    private void deleteFiles(string fpath, string fname)
    {
        string[] filesToDelete = Directory.GetFiles(fpath);

        foreach (string file in filesToDelete)
        {
            if (!file.Contains(fname + ".zip"))
            {
                File.Delete(file);
            }
        }
    }


    protected void BtnClearTrolley_Click(object sender, ImageClickEventArgs e)
    {
        Session["cart"] = null;
        GridViewCheckout.DataSource = null;
        GridViewCheckout.DataBind();
        LblMsg.Text = "Shopping trolley is empty!";

        BtnClearTrolley.Visible = false;
        HLexport.Visible = false;
    }
}
