using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.IO;
using System.Net;


/// <summary>
/// To do: progress bar (?), configuration setting in webconfig for xpath
/// userid as ipaddress; Pager setting up;
/// use search query as search result file name;
/// filter result based on lo/asset, or intelligent search based on result set (research in result);
/// for extension (search other repositories), fill and deal with repository type valuable;
/// check out if the Session_end functions works or not to remove the temp xml files
/// </summary>

public partial class _Default : System.Web.UI.Page
{
    enum repositoryType
    {
        clare = 1, jorum, llas
    };
    const int pageSize = 8;


    protected void Page_Load(object sender, EventArgs e)
    {
        LblErrMsg.Text = "";

        // to add attribute for the IE Enter key doesn't submitt problem. force IE to react to enter key 
        TextBoxSq.Attributes.Add("onkeypress", "testEnterKey('" + BtnSearch.ClientID + "');");

        if (Session["cart"] != null)
        {
            LoDset.LoOrdersDataTable cart = Session["cart"] as LoDset.LoOrdersDataTable;

            GridView1.DataSource = cart;
            GridView1.DataBind();

            HlViewDetail.Text = "View Trolley Details";
        }
        else
        {
            HlViewDetail.Text = "Trolley is Empty";
        }

        if (!IsPostBack)
        {
           string sq = "";
           if (Request.QueryString["sq"] != null)
           {
               sq = Request.QueryString["sq"];
           }

            int rtype = 0;
            if (Request.QueryString["type"] != null)
            {
                rtype = Convert.ToInt32(Request.QueryString["type"]);
            }

            int pageIndex = Convert.ToInt32(Request.QueryString["pageidx"]); //should convert null to 0

            if (sq.Length > 0)
            {
                displaySearchOutcome(sq, rtype, pageIndex);
            }
            else
            {
                DivPagingTop.Visible = false;
                DListPaging.Visible = false;
            }
                       
        }

        

    }


    private void displaySearchOutcome(string sq, int rtype, int pageIdx)
    {
        LoDset.LoProductsDataTable searchSet = getSearchSet(sq, rtype);

        int searchCount = searchSet.Rows.Count;
        if (searchCount == 0)
        {
            PanelNullOutcome.Visible = true;
            DivPagingTop.Visible = false;
            DListPaging.Visible = false;            
            return;
        }
        int startIdx = pageIdx * pageSize;
        int endIdx = pageIdx * pageSize + pageSize - 1;
        if (endIdx > (searchCount - 1))
            endIdx = searchCount - 1;

        UpdateNextPrevLinks(pageIdx, pageSize, searchCount, sq, rtype);
        UpdatePagerLocation(pageIdx, pageSize, searchCount);

        string rFilter = String.Format("productId >= {0} AND productId <= {1}", startIdx, endIdx);
        DataView currentPageSet = new DataView(searchSet, rFilter, "productId", DataViewRowState.CurrentRows);

        DataListSearch.DataSource = currentPageSet;
        DataListSearch.DataBind();

        LblSearchPhrase.Text = "Results matches \"" + sq + "\":";

    }



    private void UpdateNextPrevLinks(int pageIndex, int pageSize, int sCount, string squery, int rtype)
    {

        string navigationFormat = "Default.aspx?sq={0}&type={1}&pageidx={2}";

        PreviousPageNav.HRef = String.Format(navigationFormat, squery, rtype, pageIndex - 1);
        PreviousPageNav.Visible = (pageIndex > 0) ? true : false;

        NextPageNav.HRef = String.Format(navigationFormat, squery, rtype, pageIndex + 1);
        NextPageNav.Visible = (pageIndex + 1) * pageSize < sCount ? true : false;

        PreviousPageNavTop.HRef = String.Format(navigationFormat, squery, rtype, pageIndex - 1);
        PreviousPageNavTop.Visible = (pageIndex > 0) ? true : false;

        NextPageNavTop.HRef = String.Format(navigationFormat, squery, rtype, pageIndex + 1);
        NextPageNavTop.Visible = (pageIndex + 1) * pageSize < sCount ? true : false;
    }


    private void UpdatePagerLocation(int pageIndex, int pageSize, int sCount)
    {

        int currentStartRow = (pageIndex * pageSize) + 1;
        int currentEndRow = (pageIndex * pageSize) + pageSize;

        if (currentEndRow > sCount)
            currentEndRow = sCount;

        PagerLocation.Text = currentStartRow + "-" + currentEndRow + " of " + sCount + " Learning Objects";

        PagerLocationTop.Text = currentStartRow + "-" + currentEndRow + " of " + sCount + " Learning Objects";
    }





    protected void BtnSearch_Click(object sender, EventArgs e)
    {
        //get the repositary type
       
        if (CheckBoxListType.Items.FindByText("CLARe").Selected)
        {
            //string urlQuery = @"http://clare3.eprints.org/cgi/search/simple?_order=bytitle&basic_srchtype=ALL&type=lo&_satisfyall=ALL&_action_export=1&output=XMLFiles&q=";
            string urlQuery = @"http://clare3.eprints.org/cgi/search/simple?_order=bytitle&basic_srchtype=ALL&type=lo&_satisfyall=ALL&_action_export=1&output=XML&q=";
            
            query_remoteRepository(urlQuery, (int)repositoryType.clare);

        }
        else if (CheckBoxListType.Items.FindByText("Jorum").Selected)  //to be extended
        {
            resetForm();
            LblErrMsg.Text = "Searching of Jorum is under developement!";
        }
        else if (CheckBoxListType.Items.FindByText("LLAS").Selected)    //to be extended
        {
            resetForm();
            LblErrMsg.Text = "Searching of LLAS is under developement!";
        }
        else
        {
            resetForm();
            LblErrMsg.Text = "Please select at least one repository!";
            
        }       
        
        
    }



    private void query_remoteRepository(string basicUrlQuery, int rtype)
    {
        /* get search query and parse */
        string squery = TextBoxSq.Text.Trim();
        if (squery == "")
        {
            resetForm();
            LblErrMsg.Text = "You need to enter at lest one search keyword";
            return;
        }
        string reposQuery = makeRepositoryQstr(squery);
        /*
        string[] sqList = squery.Split(new char[] { ' ', ',' });
        squery = "";
        // if use "+" as AND delimitor, the symbol will be ignored in QueryString process
        // so it will affect the xml filenames, to read data from. now replace with "-" 
        foreach (string sq in sqList)
        {
            squery += sq + "-";
        }
        squery = squery.Substring(0, squery.Length - 1);
        */

        //the xml file for a specific query for a specific repository
        string xmlMetadata = Server.MapPath(@"App_Data\" + squery + "_" + rtype.ToString() + ".xml");

        //use the existing file as cache data in order to save a trip to remote server to retrive data
        //otherwise request file from remote server (Eprints/clare in this case)
        if (!File.Exists(xmlMetadata))
        {
            string urlQuery = basicUrlQuery + reposQuery;

            WebRequest req = WebRequest.Create(urlQuery);
            WebResponse resp = req.GetResponse();
            Stream xmlStream = resp.GetResponseStream();

            //save result back to a xml file locally, add try...catch
            StreamReader sr = new StreamReader(xmlStream);
            string contents = sr.ReadToEnd();

            //string xmlMetadata = Server.MapPath(@"App_Data\" + squery + "_" + rtype.ToString() + ".xml");
            FileStream fs = new FileStream(xmlMetadata, FileMode.Create, FileAccess.Write);
            StreamWriter sw = new StreamWriter(fs);
            sw.Write(contents);
            sw.Close();
        }

        Response.Redirect("Default.aspx?sq=" + squery + "&type=" + rtype.ToString() + "&pageidx=0");
    
    }


    private string makeRepositoryQstr(string squery)
    {
        string repQstr = "";

        //when the query string is one single word
        if (squery.IndexOf(' ') == -1)
        {
            return squery;
        }

        string[] sqList = null;
        if (squery.IndexOf("AND") > 0)
        {
            sqList = squery.Split(new string[] { "AND", " " }, StringSplitOptions.RemoveEmptyEntries);
            foreach (string sq in sqList)
            {
                repQstr += sq + "+";
            }
            repQstr = repQstr.Substring(0, repQstr.Length - 1);
            repQstr += "&q_merge=ALL";

        }
        else if (squery.IndexOf("OR") > 0)
        {
            sqList = squery.Split(new string[] { "OR", " " }, StringSplitOptions.RemoveEmptyEntries);
            foreach (string sq in sqList)
            {
                repQstr += sq + "+";
            }
            repQstr = repQstr.Substring(0, repQstr.Length - 1);
            repQstr += "&q_merge=ANY";
        }
        else  //by default, it would be "AND" connected
        {
            sqList = squery.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            foreach (string sq in sqList)
            {
                repQstr += sq + "+";
            }
            repQstr = repQstr.Substring(0, repQstr.Length - 1);
        }

        return repQstr;
        
    }




    /* get session object for search result according to search query */
    private LoDset.LoProductsDataTable getSearchSet(string qstr, int type)
    {
        //don't need type here, as all types of repositories results should be kept in one datatable
        //in other words, no matter how many repositories are chosen, it is treated as one result set
        LoDset.LoProductsDataTable searchSet = Session[qstr] as LoDset.LoProductsDataTable;

        if (searchSet == null)
        {
            searchSet = buildSearchOutputSource(qstr, type);
            Session[qstr] = searchSet;
        }
        return searchSet;

    }


    private void executeSearch(string queries)
    {
    }



    private LoDset.LoProductsDataTable buildSearchOutputSource(string qstr, int rtype)
    {
        string xmlfilepath = Server.MapPath(@"App_Data\" + qstr + "_" + rtype.ToString() + ".xml");

        LoDset ds = new LoDset(); //might need to be public

        //ds.ReadXml(path1);
        //ds.LoProducts[0].title;

        XmlDataDocument xdd = new XmlDataDocument();
      
        try
        {
            xdd.Load(xmlfilepath);
        }
        catch (System.IO.FileNotFoundException ex)
        {
            LblErrMsg.Text = ex.Message + ":Can not find the resouce file for metadata";
            LblErrMsg.ForeColor = System.Drawing.Color.Red;
            return null;
        }

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);
        nsmanager.AddNamespace("ns1", "http://eprints.org/ep2/data/2.0");

        XmlElement root = xdd.DocumentElement;
        XmlNodeList loList = root.SelectNodes("descendant::ns1:eprint", nsmanager);

        for (int i = 0; i < loList.Count; i++)
        {
            LoDset.LoProductsRow nRow = ds.LoProducts.NewLoProductsRow();
            nRow.reposId = getMetaValues(loList.Item(i), "child::ns1:eprintid", null, nsmanager);
            string[] subpaths = new string[] { "child::ns1:given", "child::ns1:family" };
            nRow.authors = getMetaValues(loList.Item(i), "child::ns1:creators/descendant::ns1:name", subpaths, nsmanager);
            nRow.title = getMetaValues(loList.Item(i), "child::ns1:title", null, nsmanager);
            nRow.description = getMetaValues(loList.Item(i), "child::ns1:description", null, nsmanager);
            nRow.type = getMetaValues(loList.Item(i), "child::ns1:type", null, nsmanager);

            nRow.reposType = rtype.ToString();

            ds.LoProducts.AddLoProductsRow(nRow);

        }

        /* to extend this by adding funtions to parsing results from other repositoreis and 
         * store data in the same datatable
         * ...... */
        
        return ds.LoProducts;
        

    }


    private string getMetaValues(XmlNode oneLO, string xpath, string[] subXpaths, XmlNamespaceManager nsm)
    {
        XmlNodeList metas = oneLO.SelectNodes(xpath, nsm);
        //In theory, only authors has more than one value, i do this just to cover the possilbe future changes
        string metaValue = "";

        if (metas.Count > 1)
        {
            for (int i = 0; i < metas.Count; i++)
            {
                if (subXpaths == null)
                {
                    metaValue += metas.Item(i).InnerText + ", ";
                }
                else
                {
                    string tempValue = "";
                    string subValue = "";
                    if (subXpaths.Length == 2 && (tempValue = metas.Item(i).SelectNodes(subXpaths[0], nsm).Item(0).InnerText) == metas.Item(i).SelectNodes(subXpaths[1], nsm).Item(0).InnerText)
                    {
                        subValue = tempValue;
                    }
                    else
                    {
                        for (int j = 0; j < subXpaths.Length; j++)
                        {
                            subValue += metas.Item(i).SelectNodes(subXpaths[j], nsm).Item(0).InnerText + " ";
                        }
                        subValue = subValue.Substring(0, subValue.Length - 1); //remove the last space
                    }
                    metaValue += subValue + ", ";
                }
            }
            //remove the last ", "
            metaValue = metaValue.Substring(0, metaValue.Length - 2);

        }
        else if (metas.Count == 1)
        {
            if (subXpaths == null)
            {
                metaValue = metas.Item(0).InnerText;
            }
            else
            {
                string tempValue = "";
                //this is for the specila case when given name and family name are the same  (not good)
                if (subXpaths.Length == 2 && (tempValue = metas.Item(0).SelectNodes(subXpaths[0], nsm).Item(0).InnerText) == metas.Item(0).SelectNodes(subXpaths[1], nsm).Item(0).InnerText)
                {
                    metaValue = tempValue;
                }
                else
                {
                    for (int j = 0; j < subXpaths.Length; j++)
                    {
                        metaValue += metas.Item(0).SelectNodes(subXpaths[j], nsm).Item(0).InnerText + " ";

                    }
                    metaValue = metaValue.Substring(0, metaValue.Length - 1); //remove the last space
                }

            }
        }

        return metaValue;
    }



    private LoDset.LoOrdersDataTable getShoppingCartData()
    {
        LoDset.LoOrdersDataTable cartSet = Session["cart"] as LoDset.LoOrdersDataTable;

               
        if (cartSet == null)
        {
            cartSet = new LoDset.LoOrdersDataTable();
        }

        return cartSet;


    }


    protected void DataListSearch_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.CommandName == "addToCart")
        {
           
            string pid = DataListSearch.DataKeys[e.Item.ItemIndex].ToString();

            LoDset.LoOrdersDataTable currCart = getShoppingCartData();

            int type = (Request.QueryString["type"] != null) ? Convert.ToInt32(Request.QueryString["type"]) : 0;
            string squery = Request.QueryString["sq"];
            LoDset.LoProductsDataTable currSearchSet = getSearchSet(squery, type);

            if (currSearchSet == null || currSearchSet.Rows.Count == 0)
            {
                resetForm();
                LblErrMsg.Text = "The search is timed out. Please search again!";
                return;
            }
            
            //check if exising rows with the same product Id
            //DataRow[] existingRows = curSet.LoOrders.Select("productId=" + pid);

            //use repository id instead, as product id can be duplicated when a new search is conducted
            //firstly, get the current product being selected and to be added
            LoDset.LoProductsRow curProductRow = currSearchSet.FindByproductId(Convert.ToInt32(pid));
            DataRow[] existingRows = currCart.Select("reposId=" + curProductRow.reposId);
            Trace.Write("repository ID to add: " + curProductRow.reposId);
            
            for (int i = 0; i < currCart.Rows.Count; i++)
            {
                Trace.Write("current repositoray id in cart: " + currCart.Rows[i]["reposId"]);
            }

            if (existingRows.Length > 0)
            {
                LblErrMsg.Text = "The current learning object is already in the shopping Trolley!";
                return;
            }

            //decide if the same user working on the shopping trolley or not
            int numofRows = currCart.Rows.Count;
            if (numofRows > 0)
            {
                string prevUser = currCart.Rows[numofRows - 1]["userId"].ToString();
                if (!Request.UserHostAddress.Equals(prevUser))
                {
                    LblErrMsg.Text = "Please clear the Cart first!";
                    return;
                }
            }


            LoDset.LoOrdersRow newOrder = currCart.NewLoOrdersRow();

            //the current product being selected and to be added
           // LoDset.LoProductsRow curProductRow = curSet.LoProducts.FindByproductId(Convert.ToInt32(pid));

            newOrder.productId = curProductRow.productId;
            newOrder.userId = Request.UserHostAddress;
            newOrder.reposId = curProductRow.reposId;
            newOrder.title = curProductRow.title;
            newOrder.authors = curProductRow.authors;
            newOrder.description = curProductRow.description;
            newOrder.reposType = curProductRow.reposType;
            newOrder.type = curProductRow.type;

            //add the embeded files into the datatable
            /* method 1: download binary files at search, then read from seach result xml file at this stage  *
             * 
            string[] fileDetails = getEmbeddedFileStrings(squery, type, curProductRow.reposId, curProductRow.type);
             */

            /* method 2: download xml file for each LO/asset at the time of adding to trolley *
             * then read and parse this xml file to upadate current cart datatable 
             */
            string[] fileDetails = getEmbeddedFileStringv2(curProductRow.reposId, curProductRow.type);
            newOrder.filename = fileDetails[0];
            newOrder.content = fileDetails[1];

            currCart.AddLoOrdersRow(newOrder);

            Session["cart"] = currCart;  //update cart session

            HlViewDetail.Text = "View Trolley Details";
            

            GridView1.DataSource = currCart;
            GridView1.DataBind();

        }

    }


    protected void Page_Unload(object sender, EventArgs e)
    {
       // File.Delete(Server.MapPath(@"App_Data\_1.xml"));        
        

    }


    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            Label lblIdx = (Label)e.Row.FindControl("IndexLbl");
            lblIdx.Text = Convert.ToString(e.Row.RowIndex + 1);

        }

    }

    private string[] getEmbeddedFileStrings(string sq, int repType, string repositoryId, string objType)
    {
        string xmlfilepath = Server.MapPath(@"App_Data\" + sq + "_" + repType.ToString() + ".xml");

        XmlDataDocument xdd = new XmlDataDocument();
      
        try
        {
            xdd.Load(xmlfilepath);
        }
        catch (System.IO.FileNotFoundException ex)
        {
            LblErrMsg.Text = ex.Message + ":Can not find the resouce file for metadata (embedded file)";
            return null;
        }

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);
        nsmanager.AddNamespace("ns1", "http://eprints.org/ep2/data/2.0");

        XmlElement root = xdd.DocumentElement;
        XmlNodeList allLoRecords = root.SelectNodes("descendant::ns1:eprint", nsmanager);
        string fileName = "";
        string fileBinaryString = "";

        for (int i = 0; i < allLoRecords.Count; i++)
        {
           XmlNodeList eprintIds = allLoRecords.Item(i).SelectNodes("child::ns1:eprintid", nsmanager);
           //eprintId has only one result item(0)
           if (eprintIds.Item(0).InnerText == repositoryId)
           {
               if (objType == "lo")
               {
                   XmlNodeList allFiles = allLoRecords.Item(i).SelectNodes("child::ns1:documents/ns1:document/ns1:files/ns1:file", nsmanager);
                   for (int j = 0; j < allFiles.Count; j++)
                   {
                       fileName = allFiles.Item(j).SelectNodes("child::ns1:filename", nsmanager).Item(0).InnerText;
                       if (fileName.IndexOf(".zip") >= 0)
                       {
                           XmlNodeList fileContents = allFiles.Item(j).SelectNodes("child::ns1:data", nsmanager);
                           fileBinaryString = fileContents.Item(0).InnerText;
                           break;
                       }
                   }
               }
               else if (objType == "asset")
               {
                   XmlNodeList assetFile = allLoRecords.Item(i).SelectNodes("child::ns1:documents/ns1:document/ns1:files/ns1:file", nsmanager);

                   fileName = assetFile.Item(0).SelectNodes("child::ns1:filename", nsmanager).Item(0).InnerText;
                   fileBinaryString = assetFile.Item(0).SelectNodes("child::ns1:data", nsmanager).Item(0).InnerText;
               }
               break;

           }
        }

        string[] fileDetail = new string[] { fileName, fileBinaryString };
        return fileDetail;
        
    }


    private string[] getEmbeddedFileStringv2(string reposId, string objType)
    {
        loadXMLbasedOnId(reposId); //create file first

        string xmlfilepath = Server.MapPath(@"App_Data\" + reposId + ".xml");

        XmlDataDocument xdd = new XmlDataDocument();

        try
        {
            xdd.Load(xmlfilepath);
        }
        catch (System.IO.FileNotFoundException ex)
        {
            LblErrMsg.Text = ex.Message + ":Can not find the resouce file for metadata (embedded file)";
            return null;
        }

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);
        nsmanager.AddNamespace("ns1", "http://eprints.org/ep2/data/2.0");

        XmlElement root = xdd.DocumentElement;
       
        string fileName = "";
        string fileBinaryString = "";

        if (objType == "lo")
        {
            XmlNodeList allFiles = root.SelectNodes("child::ns1:documents/ns1:document/ns1:files/ns1:file", nsmanager);
            for (int j = 0; j < allFiles.Count; j++)
            {
                fileName = allFiles.Item(j).SelectNodes("child::ns1:filename", nsmanager).Item(0).InnerText;
                if (fileName.IndexOf(".zip") >= 0)
                {
                    XmlNodeList fileContents = allFiles.Item(j).SelectNodes("child::ns1:data", nsmanager);
                    fileBinaryString = fileContents.Item(0).InnerText;
                    break;
                }
            }
        }
        else if (objType == "asset")
        {
            XmlNodeList assetFile = root.SelectNodes("child::ns1:documents/ns1:document/ns1:files/ns1:file", nsmanager);

            fileName = assetFile.Item(0).SelectNodes("child::ns1:filename", nsmanager).Item(0).InnerText;
            fileBinaryString = assetFile.Item(0).SelectNodes("child::ns1:data", nsmanager).Item(0).InnerText;
        }
               

        string[] fileDetail = new string[] { fileName, fileBinaryString };
        return fileDetail;

    }



    private void loadXMLbasedOnId(string epid)
    {
        string xmlpath = Server.MapPath(@"App_Data\" + epid + ".xml");
        string baseURL = @"http://clare3.eprints.org/cgi/export/{0}/XMLFiles/clare-eprint-{1}.xml";

        if (!File.Exists(xmlpath))
        {
            string urlQuery = String.Format(baseURL, epid, epid);

            WebRequest req = WebRequest.Create(urlQuery);
            WebResponse resp = req.GetResponse();
            Stream xmlStream = resp.GetResponseStream();

            //save result back to a xml file locally, add try...catch
            StreamReader sr = new StreamReader(xmlStream);
            string contents = sr.ReadToEnd();
                        
            FileStream fs = new FileStream(xmlpath, FileMode.Create, FileAccess.Write);
            StreamWriter sw = new StreamWriter(fs);
            sw.Write(contents);
            sw.Close();
        }
    }


    protected void BtnReset_Click(object sender, EventArgs e)
    {
        TextBoxSq.Text = "";
        resetForm();

    }


    private void resetForm()
    {
        
        LblErrMsg.Text = "";
        LblSearchPhrase.Text = "";
        PanelNullOutcome.Visible = false;

        DivPagingTop.Visible = false;
        DListPaging.Visible = false;

        DataListSearch.DataSource = null;
        DataListSearch.DataBind();
    }


}
