using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using ICSharpCode.SharpZipLib.Zip;



public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }


    protected void BtnImport_Click(object sender, EventArgs e)
    {
        string clientFileName = "";
        string serverSavePath = Server.MapPath(@"App_Data");
        string serverFileName = "";

        //remove files from the previous operations
        removeFiles();

        if ((FileUploadBox.PostedFile !=null) && (FileUploadBox.PostedFile.ContentLength > 0))
        {
            clientFileName = Path.GetFileName(FileUploadBox.PostedFile.FileName);
           
            
            //attach the relevatn suffix
            string pathName = clientFileName.Substring(0,clientFileName.LastIndexOf("."));
            serverSavePath = serverSavePath + "\\" + pathName;

            if (!Directory.Exists(serverSavePath))
            {
                Directory.CreateDirectory(serverSavePath);
            }
            serverFileName = serverSavePath + "\\" + clientFileName;

            try
            {
                FileUploadBox.PostedFile.SaveAs(serverFileName);
                UnzipPackage(serverFileName);

                if (!processFiles(serverSavePath, serverFileName))
                {
                    return;
                }              
                
                //link to the editor website
                Response.Redirect("metaEdit.aspx?mtype=1&filedir=" + pathName);
                
            }
            catch (Exception ex)
            {
                
                lblErrMsg.Text = "An error occurred while saving this file to server, please try again. <Br>Message: " + ex.Message;
            }

        }

    }


    private bool processFiles(string fileDir, string zipfileName)
    {
        File.Delete(zipfileName);
        
        string metaFile = fileDir + "\\" + "imsmanifest.xml";
        if (File.Exists(metaFile))
        {
            string dataFile = Server.MapPath(@"App_Data") + "\\" + "imsmanifest.xml";
            File.Copy(metaFile, dataFile, true);
            return true;
        }
        else
        {
            lblErrMsg.Text = "The content package is not valid, please reload";
            return false;
        }
    }


    private void UnzipPackage(string zipPath)
    {
        ZipInputStream s = new ZipInputStream(File.OpenRead(zipPath));

        ZipEntry theEntry;
        while ((theEntry = s.GetNextEntry()) != null)
        {

            string directoryName = Path.GetDirectoryName(theEntry.Name);
            string fileName = Path.GetFileName(theEntry.Name);

            if (fileName != String.Empty)
            {
                string unzippedFile = "";
                /* When subdirectories are in the zip file*/
                if (directoryName != "")
                {
                    string subDir = zipPath.Substring(0, zipPath.LastIndexOf("\\")) + "\\" + directoryName;
                    if (!Directory.Exists(subDir))
                    {
                        Directory.CreateDirectory(subDir);
                    }

                    unzippedFile = subDir + "\\" + fileName;
                }
                else
                {
                    unzippedFile = zipPath.Substring(0, zipPath.LastIndexOf("\\")) + "\\" + fileName;
                }

                FileStream streamWriter = File.Create(unzippedFile);

                int size = 2048;
                byte[] data = new byte[2048];
                while (true)
                {
                    size = s.Read(data, 0, data.Length);
                    if (size > 0)
                    {
                        streamWriter.Write(data, 0, size);
                    }
                    else
                    {
                        break;
                    }
                }

                streamWriter.Close();
            }
        }
        s.Close();

    }

    private void removeFiles()
    {
        //string delFile = Server.MapPath("App_Data") + "\\" + "imsmanifest.xml";

        string[] files = Directory.GetFiles(Server.MapPath("App_Data"));

        foreach (string ifile in files)
        {
            if (ifile.EndsWith(".zip"))
            {
                File.Delete(ifile);
            }
            else if (ifile.EndsWith("imsmanifest.xml"))
            {
                File.Delete(ifile);
            }
        }

        // Directory.Delete(delDir, true);

    }


}
