namespace testEditor
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.IO;

	/// <summary>
	///		Summary description for toolbar.
	/// </summary>
	public class toolbar : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Button BtnEdit;
		protected System.Web.UI.WebControls.Button BtnView;
		protected System.Web.UI.WebControls.Button BtnVersions;
		protected System.Web.UI.WebControls.Button BtnExport;
		protected System.Web.UI.WebControls.Button BtnNew;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here

			//BtnEdit.CommandName = "editLO";
			if (Request["action"] == "view")
			{
				BtnEdit.Visible = true;
				BtnView.Visible = false;
				BtnExport.Visible = true;
			}
			else if (Request["action"] == "edit")
			{
				BtnEdit.Visible = false;
				BtnView.Visible = true;
				BtnExport.Visible = false;
			}
				
			else if (Request["action"] == "showvariants")
			{
				BtnEdit.Visible = false;
				BtnView.Visible = true;
				BtnVersions.Visible = false;
				BtnExport.Visible = true;
			}
			else
			{
				BtnEdit.Visible = false;
				BtnView.Visible = false;
				BtnVersions.Visible = false;

				BtnExport.Visible = false;
			}
			
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.BtnEdit.Click += new System.EventHandler(this.BtnEdit_Click);
			this.BtnView.Click += new System.EventHandler(this.BtnView_Click);
			this.BtnVersions.Click += new System.EventHandler(this.BtnVersions_Click);
			this.BtnNew.Click += new System.EventHandler(this.BtnNew_Click);
			this.BtnExport.Click += new System.EventHandler(this.BtnExport_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void BtnEdit_Click(object sender, System.EventArgs e)
		{
			string loTitle = "";

			if (Request["title"] != null)
			{
				loTitle = Request["title"].ToString();
			}
			else if (Session["lotitle"] != null)
			{
				loTitle = Session["lotitle"].ToString();
			}
			else
			{
				Response.Write("This page is timed out, please select your learning object again");
				return;
			}
			
			
			/*
			if (BtnEdit.CommandName == "editLO")
			{
				BtnEdit.Text = "View LO";
				BtnEdit.CommandName = "viewLO";

				Response.Redirect("LOedit.aspx?title=" + loTitle + "&action=edit"); 

			}
			else if (BtnEdit.CommandName == "viewLO")
			{
				BtnEdit.Text = "Edit LO";
				BtnEdit.CommandName = "editLO";

				Response.Redirect("LOedit.aspx?title=" + loTitle + "&action=view"); 
			}
			*/

			
			
			if (Request["var"] != null)
			{
				Response.Redirect("LOedit.aspx?title=" + loTitle + "&action=edit" + "&var=" + Request["var"].ToString());

			}
			else
			{
				Response.Redirect("LOedit.aspx?title=" + loTitle + "&action=edit"); 
			}
		
		}


		private void BtnView_Click(object sender, System.EventArgs e)
		{
			string loTitle = "";
			
			if (Request["title"] != null)
			{
				loTitle = Request["title"].ToString();			
			}
			else if (Session["lotitle"] != null)
			{
			    loTitle = Session["lotitle"].ToString();
			}
			else
			{
				Response.Write("This page is timed out, please select your learning object agian");
				return;
			}

			//try whether the request["var"] has value or not
			if (Request["var"] != null)
			{
				Response.Redirect("LOedit.aspx?title=" + loTitle + "&action=view" + "&var=" + Request["var"].ToString());

			}
			else
			{
				Response.Redirect("LOedit.aspx?title=" + loTitle + "&action=view"); 
			}
		
		}



		private void BtnNew_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("importPage.aspx");
		}



		private void BtnVersions_Click(object sender, System.EventArgs e)
		{
			string loId = "";			

			if (Request["title"] != null)
			{
				loId = Request["title"].ToString();
			}
			else if (Session["lotitle"] != null)
			{
				loId = Session["lotitle"].ToString();				
			}
			else
			{
				Response.Write("This page is timed out, please select your learning object agian");
				return;
			}
			Response.Redirect("variants.aspx?title="+loId+"&action=showvariants");
		
		}

		private void BtnExport_Click(object sender, System.EventArgs e)
		{
			string loTitle = "";
			string var = "";
			if (Request["title"] != null)
			{
				loTitle = Request["title"].ToString();
			}
			else if(Session["lotitle"] != null)
			{
				loTitle = Session["lotitle"].ToString();				
			} 
			else
			{
				Response.Write("This page is timed out, please select your learning object agian");
				return;
			}

			if (Session["varNum"] != null)
			{
				var = Session["varNum"].ToString();
			}

			exportZipFile(loTitle,var);

            
		}



		private void exportZipFile(string title,string varNum)
		{
			
			string strPath = Request.PhysicalApplicationPath + "variants\\" + title + "\\" + title + "_v" + varNum + ".zip";

			FileInfo zipfile = new FileInfo(strPath);

			//Clear the current output content from the buffer
			Response.Clear();

			string newName = title + ".zip";

			//Add the header that specifies the default filename for the Download/SaveAs dialog
			Response.AddHeader("Content-Disposition", "attachment;filename=" + newName);

			//Add the header that specifies the file size, so that the browser 
			//can show the download progress
			Response.AddHeader("Content-Length", zipfile.Length.ToString());

			//Specify that the response is a stream that cannot be read by the client 
			//and must be downloaded
			Response.ContentType = "application/zip";

			//Send the file stream to the client
			Response.WriteFile(zipfile.FullName);

			//Stop the execution of this page
			Response.End();
		}
	}
}
